#include <RCSwitch.h>                 //Bibliothek für das Funkmodul 868MHz oder 433MHz
RCSwitch mySwitch = RCSwitch();       //Das Funkmodul wird ab jetzt mit "mySwitch" angesprochen
#include <HX711.h>                    //Bibliothek für den Waagesensor HX711
                                      //HX711.DT  an Pin A1
                                      //HX711.SCK an Pin A0

HX711 scale;
int Code = 1234;                      //Hier den zu sendenden Code eingeben
int val;
int Toleranz = 300;                   //Hier erforderlichen Druck auf den Schalter eingeben (ohne Druck = 0, leichtes Antippen = 50, normal drücken = 200)


void setup()
{
  mySwitch.enableTransmit(3);         // Der Sender wird an Pin 3 angeschlossen
  
  Serial.begin(9600);
  scale.begin(A1, A0);                //HX711.DT an Pin A1, HX711.SCK an Pin A0
  scale.set_scale(320.f);    
  scale.tare();              
  Serial.print("read: \t\t");
  Serial.println(scale.read());            //gibt eine einzelne Messung auf dem seriellen Monitor aus
  Serial.print("read average: \t\t");
  Serial.println(scale.read_average(15));  //gibt den Durchschnitt von 15 Messungen aus
  Serial.print("get units: \t\t");
  Serial.println(scale.get_units(5), 1);   //gibt den Durchschnitt von 5 Messungen aus minus Tara, geteilt durch den scale-Wert
}


void loop()
{
  val = scale.get_units(3);           //gibt den Durchschnitt von 3 Messungen in die Variable val aus
  delay(200);
  Serial.println(val);
  
 if(val > Toleranz) 
 {
    mySwitch.send(Code, 24);          //Das Funkmodul sendet den Code drei Mal
    delay(10);  
    mySwitch.send(Code, 24);
    delay(10);  
    mySwitch.send(Code, 24); 
    delay(10);  
 }

}




